/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.updates;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;

public class BaseUpdaterException
extends HException {
    public static final String XMCM_EVENT_ID_CM_GENERAL = "LIC_EVENT";
    private static final String TRACE_MASKT = "XMCMBUET";
    private static final String TRACE_MASKF = "XMCMBUEF";
    private static final String TRACE_MASKD = "XMCMBUED";
    private MessageText messageText;
    private short reasonCode;

    public BaseUpdaterException(short reasonCode, String text) {
        super(text);
        Trace.trace(TRACE_MASKT, "-> BaseUpdaterException(" + text + ")");
        this.messageText = null;
        this.logError(reasonCode, this, null);
        Trace.trace(TRACE_MASKT, "<- BaseUpdaterException()");
    }

    public BaseUpdaterException(short reasonCode, String text, LocalizableText[] parms) {
        super(text);
        Trace.trace(TRACE_MASKT, "-> BaseUpdaterException(" + text + ")");
        this.messageText = null;
        this.logError(reasonCode, this, parms);
        Trace.trace(TRACE_MASKT, "<- BaseUpdaterException()");
    }

    public BaseUpdaterException(short reasonCode, String text, LocalizableText[] parms, boolean logAsInformational, byte logType, String eventId) {
        super(text);
        Trace.trace(TRACE_MASKT, "-> BaseUpdaterException(" + text + ")");
        this.messageText = null;
        this.logError(reasonCode, this, parms, logAsInformational, logType, eventId);
        Trace.trace(TRACE_MASKT, "<- BaseUpdaterException()");
    }

    public BaseUpdaterException(short reasonCode, Throwable thrown) {
        super(thrown);
        Trace.trace(TRACE_MASKT, "-> BaseUpdaterException( Throwable: " + thrown + ")");
        this.messageText = null;
        if (thrown instanceof BaseUpdaterException) {
            BaseUpdaterException piexc = (BaseUpdaterException)thrown;
            Trace.trace(TRACE_MASKF, "Calling logError with previously thrown exception " + thrown);
            this.logError(reasonCode, piexc, null);
        } else {
            Trace.trace(TRACE_MASKF, "Printing out stack trace from original exception.");
            StackTraceElement[] stackTrace = thrown.getStackTrace();
            for (int j = 0; j < stackTrace.length; ++j) {
                Trace.trace(TRACE_MASKF, stackTrace[j].toString());
            }
            this.logError(reasonCode, this, null);
        }
        Trace.trace(TRACE_MASKT, "<- BaseUpdaterException()");
    }

    public BaseUpdaterException(short reasonCode, Throwable thrown, LocalizableText[] parms) {
        super(thrown);
        Trace.trace(TRACE_MASKT, "-> BaseUpdaterException( Throwable: " + thrown + ")");
        this.messageText = null;
        if (thrown instanceof BaseUpdaterException) {
            BaseUpdaterException piexc = (BaseUpdaterException)thrown;
            Trace.trace(TRACE_MASKF, "Calling logError with previously thrown exception " + thrown);
            this.logError(reasonCode, piexc, parms);
        } else {
            Trace.trace(TRACE_MASKF, "Printing out stack trace from original exception.");
            StackTraceElement[] stackTrace = thrown.getStackTrace();
            for (int j = 0; j < stackTrace.length; ++j) {
                Trace.trace(TRACE_MASKF, stackTrace[j].toString());
            }
            this.logError(reasonCode, this, parms);
        }
        Trace.trace(TRACE_MASKT, "<- BaseUpdaterException()");
    }

    public BaseUpdaterException(short reasonCode, Throwable thrown, LocalizableText[] parms, boolean logAsInformational, byte logType, String eventId) {
        super(thrown);
        Trace.trace(TRACE_MASKT, "-> BaseUpdaterException( Throwable: " + thrown + ")");
        this.messageText = null;
        if (thrown instanceof BaseUpdaterException) {
            BaseUpdaterException piexc = (BaseUpdaterException)thrown;
            Trace.trace(TRACE_MASKF, "Calling logError with previously thrown exception " + thrown);
            this.logError(reasonCode, piexc, parms, logAsInformational, logType, eventId);
        } else {
            Trace.trace(TRACE_MASKF, "Printing out stack trace from original exception.");
            StackTraceElement[] stackTrace = thrown.getStackTrace();
            for (int j = 0; j < stackTrace.length; ++j) {
                Trace.trace(TRACE_MASKF, stackTrace[j].toString());
            }
            this.logError(reasonCode, this, parms, logAsInformational, logType, eventId);
        }
        Trace.trace(TRACE_MASKT, "<- BaseUpdaterException()");
    }

    public int getReasonCode() {
        return this.reasonCode;
    }

    public MessageText getMessageText() {
        return this.messageText;
    }

    public static void logInformationalEvent(String eventId, String verbiage) {
        Trace.trace(TRACE_MASKT, "-> logInformationalEvent()");
        byte logClass = 46;
        byte logType = 0;
        Log event = new Log(logClass, logType, 0, eventId, null, null, null, null);
        byte blockId = -128;
        event.add(blockId, verbiage);
        LogAttributes attributes = new LogAttributes(false, false, false, false);
        event.log(attributes);
        Trace.trace(TRACE_MASKT, "<- logInformationalEvent()");
    }

    public static void logMicrocodeError(short reasonCode, String text) {
        Trace.trace(TRACE_MASKT, "-> logMicrocodeError(" + text + ")");
        BaseUpdaterException exc = new BaseUpdaterException(reasonCode, text);
        Trace.trace(TRACE_MASKT, "<- logMicrocodeError()");
    }

    public static void logMicrocodeError(short reasonCode, String text, LocalizableText[] parms) {
        Trace.trace(TRACE_MASKT, "-> logMicrocodeError(" + text + ")");
        BaseUpdaterException exc = new BaseUpdaterException(reasonCode, text, parms);
        Trace.trace(TRACE_MASKT, "<- logMicrocodeError()");
    }

    public static void logMicrocodeError(short reasonCode, String text, LocalizableText[] parms, boolean logAsInformational, byte logType, String eventId) {
        Trace.trace(TRACE_MASKT, "-> logMicrocodeError(" + text + ")");
        BaseUpdaterException exc = new BaseUpdaterException(reasonCode, text, parms, logAsInformational, logType, eventId);
        Trace.trace(TRACE_MASKT, "<- logMicrocodeError()");
    }

    public static void logMicrocodeError(short reasonCode, Throwable thrown) {
        Trace.trace(TRACE_MASKT, "-> logMicrocodeError( Throwable: " + thrown + ")");
        BaseUpdaterException exc = new BaseUpdaterException(reasonCode, thrown);
        Trace.trace(TRACE_MASKT, "<- logMicrocodeError()");
    }

    public static void logMicrocodeError(short reasonCode, Throwable thrown, LocalizableText[] parms) {
        Trace.trace(TRACE_MASKT, "-> logMicrocodeError( Throwable: " + thrown + ")");
        BaseUpdaterException exc = new BaseUpdaterException(reasonCode, thrown, parms);
        Trace.trace(TRACE_MASKT, "<- logMicrocodeError()");
    }

    public static void logMicrocodeError(short reasonCode, Throwable thrown, LocalizableText[] parms, boolean logAsInformational, byte logType, String eventId) {
        Trace.trace(TRACE_MASKT, "-> logMicrocodeError( Throwable: " + thrown + ")");
        BaseUpdaterException exc = new BaseUpdaterException(reasonCode, thrown, parms, logAsInformational, logType, eventId);
        Trace.trace(TRACE_MASKT, "<- logMicrocodeError()");
    }

    protected void logError(short reasonCode, HException hexc, LocalizableText[] parms) {
        byte logType = 2;
        String eventId = "XMCL";
        this.logError(reasonCode, hexc, parms, false, logType, eventId);
    }

    protected void logError(short reasonCode, HException hexc, LocalizableText[] parms, boolean logAsInformational, byte logType, String eventId) {
        Trace.trace(TRACE_MASKF, "logError code = " + reasonCode);
        this.reasonCode = reasonCode;
        FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(logType, eventId);
        if (logAsInformational) {
            MicrocodeLogAttributes attribs = new MicrocodeLogAttributes(false);
            new FrameworkLog(logInfo, reasonCode, hexc).log(attribs);
        } else {
            new FrameworkLog(logInfo, reasonCode, hexc).log();
        }
        String bundleName = "com/ibm/hwmca/base/res/message";
        String key = reasonCode == 111 ? "MCL0040" : "MCL1724";
        if (hexc instanceof BaseUpdaterException) {
            BaseUpdaterException piexc = (BaseUpdaterException)hexc;
            this.messageText = piexc.getMessageText();
            if (this.messageText != null) {
                Trace.trace(TRACE_MASKD, "Copied message from original exception" + this.messageText.toString());
            }
        }
        if (this.messageText == null) {
            if (parms == null) {
                this.messageText = new MessageText(bundleName, key);
                Trace.trace(TRACE_MASKD, "message=" + this.messageText.toString());
            } else {
                this.messageText = new MessageText(bundleName, key, parms);
                Trace.trace(TRACE_MASKD, "message=" + this.messageText.toString());
                Trace.trace(TRACE_MASKD, "parms[0]=[" + parms[0] + "]");
            }
        }
        Trace.trace(TRACE_MASKD, "Logged error for exception " + this);
    }
}

